<?php
$user_role = auth()->user()->role;
$admin = 1;
?>


<?php if(auth()->user()->can('add-covered-countries') || $user_role == $admin): ?>
    <li class="nav-item  <?php echo e(areActiveRoutes(['countries.index'], 'menu-is-opening menu-open active')); ?>">
        <a href="<?php echo e(fr_route('countries.index')); ?>"
            class="nav-link <?php echo e(areActiveRoutes(['countries.index'], 'menu-is-opening menu-open active')); ?>">
            <i class="fas fa-map-marked-alt fa-fw"></i>
            <p><?php echo e(__('cargo::view.covered_places')); ?></p>
        </a>
    </li>
<?php endif; ?>

<?php if(auth()->user()->can('manage-areas') || $user_role == $admin): ?>
    <li class="nav-item <?php echo e(areActiveRoutes(['areas.index'], 'menu-is-opening menu-open active')); ?>">
        <a href="<?php echo e(fr_route('areas.index')); ?>"
            class="nav-link <?php echo e(areActiveRoutes(['areas.index'], 'menu-is-opening menu-open active')); ?>">
            <i class="fas fa-directions fa-fw"></i>
            <p><?php echo e(__('cargo::view.areas_management')); ?></p>
        </a>
    </li>
<?php endif; ?>

<?php if(auth()->user()->can('manage-delivery-time') || $user_role == $admin): ?>
    <li class="nav-item <?php echo e(areActiveRoutes(['deliveryTime.index'], 'menu-is-opening menu-open active')); ?>">
        <a href="<?php echo e(fr_route('deliveryTime.index')); ?>"
            class="nav-link  <?php echo e(areActiveRoutes(['deliveryTime.index'], 'menu-is-opening menu-open active')); ?>">
            <i class="fas fa-clock fa-fw"></i>
            <p><?php echo e(__('cargo::view.delivery_time')); ?></p>
        </a>
    </li>
<?php endif; ?>

<?php if(auth()->user()->can('manage-packages') || $user_role == $admin): ?>
    <li class="nav-item <?php echo e(areActiveRoutes(['packages.index'], 'menu-is-opening menu-open active')); ?>">
        <a href="<?php echo e(fr_route('packages.index')); ?>"
            class="nav-link <?php echo e(areActiveRoutes(['packages.index'], 'menu-is-opening menu-open active')); ?>">
            <i class="fas fa-cubes fa-fw"></i>
            <p><?php echo e(__('cargo::view.packages')); ?></p>
        </a>
    </li>
<?php endif; ?>

<?php if(auth()->user()->can('shipping-rates') || $user_role == $admin): ?>
    <li class="nav-item <?php echo e(areActiveRoutes(['shipments.settings.fees'], 'menu-is-opening menu-open active')); ?>">
        <a href="<?php echo e(fr_route('shipments.settings.fees')); ?>"
            class="nav-link <?php echo e(areActiveRoutes(['shipments.settings.fees'], 'menu-is-opening menu-open active')); ?>">
            <i class="fas fa-dollar-sign fa-fw"></i>
            <p><?php echo e(__('cargo::view.shipping_rates')); ?></p>
        </a>
    </li>
<?php endif; ?>

<?php if(auth()->user()->can('shipping-settings') || $user_role == $admin): ?>
    <li class="nav-item <?php echo e(areActiveRoutes(['shipments.settings'], 'menu-is-opening menu-open active')); ?>">
        <a href="<?php echo e(fr_route('shipments.settings')); ?>"
            class="nav-link <?php echo e(areActiveRoutes(['shipments.settings'], 'menu-is-opening menu-open active')); ?>">
            <i class="fas fa-cog fa-fw"></i>
            <p><?php echo e(__('cargo::view.shipping_settings')); ?></p>
        </a>
    </li>
<?php endif; ?>
<?php /**PATH /home/elitedesigncom/courier.elitedesign.com.bd/Modules/Cargo/Resources/views/adminLte/components/aside_menu_settings.blade.php ENDPATH**/ ?>