<?php
$user_role = auth()->user()->role;
$admin = 1;
$branch = 3;
$client = 4;
?>


<?php if(in_array('type', $filters)): ?>
    <div class="mb-10">
        <!--begin::Label-->
        <label class="form-label fs-5 fw-bold mb-3"><?php echo e(__('cargo::view.type')); ?>:</label>
        <!--end::Label-->
        <!--begin::Options-->
        <div class="d-flex flex-column flex-wrap fw-bold">
            <select class="form-control  select-branch" data-control="select2" data-placeholder="<?php echo e(__('cargo::view.type')); ?>" data-allow-clear="true" name="<?php echo e($table_id); ?>_type">
                <option></option>
                <option value="1"><?php echo e(__('cargo::view.PICKUP_TYPE')); ?> </option>
                <option value="2"><?php echo e(__('cargo::view.DELIVERY_TYPE')); ?> </option>
                <option value="3"><?php echo e(__('cargo::view.RETURN_TYPE')); ?> </option>
                <option value="4"><?php echo e(__('cargo::view.SUPPLY_TYPE')); ?> </option>
                <option value="5"><?php echo e(__('cargo::view.TRANSFER_TYPE')); ?> </option>
            </select>
            <!--end::Option-->
        </div>
        <!--end::Options-->
    </div>




    
    <?php $__env->startPush('js-component'); ?>
        <script>
            $(window).on('load', function() {
                setTimeout(() => {
                    var table_id = '<?php echo e($table_id); ?>';
                    var typSelect = $(`[name="${ table_id }_type"]`)
                    var dataTableInstance = $(`#${table_id}`).DataTable();
                    var formOptions = $(`#${table_id}_filter_options_form`);


                    typSelect.on('change', function(e) {
                        var value = $(this).val(),

                            typSelectChecked = typSelect.filter(':checked')
                        // get data by selected roles
                        dataTableInstance.on('preXhr.dt', function(e, settings, data) {
                            if (!data.filter) {
                                data.filter = {}
                            }

                            data.filter.type = value;
                            console.log(data.filter);
                        })
                        // dataTableInstance.ajax.reload()
                    })
                    formOptions.on('reset', function(e) {
                        dataTableInstance.on('preXhr.dt', function(e, settings, data) {
                            if (data.filter) {
                                data.filter.type = '';
                            }
                        })
                        // dataTableInstance.ajax.reload()
                    })
                }, 1000);
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>
<?php /**PATH /home/elitedes/courier.elitedesign.com.bd/Modules/Cargo/Resources/views/adminLte/pages/missions/table/filters/type.blade.php ENDPATH**/ ?>