<?php
    if (check_module('Localization')) {
        $current_lang = Modules\Localization\Entities\Language::where('code', LaravelLocalization::getCurrentLocale())->first();
    }
?>
<!DOCTYPE html>
<?php if(isset($current_lang) && $current_lang->dir == 'rtl'): ?>
<html lang="<?php echo e(LaravelLocalization::getCurrentLocale()); ?>" direction="rtl" dir="rtl" style="direction: rtl;">
<?php else: ?>
<html lang="<?php echo e(LaravelLocalization::getCurrentLocale()); ?>">
<?php endif; ?>
    <head>
        <title><?php echo e(config('app.name') . ' | ' . ($pageTitle ?? 'Dashboard')); ?></title>
        <meta name="description" content="Algoriza - Framework" />
        <meta name="keywords" content="Algoriza - Framework" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <meta charset="utf-8" />
        <meta property="og:locale" content="en_US" />
        <meta property="og:type" content="article" />
        <meta property="og:title" content="<?php echo e(config('app.name')); ?>" />

        <?php 
            $model = App\Models\Settings::where('group', 'general')->where('name','system_logo')->first();
        ?>
        <link rel="shortcut icon" href="<?php echo e($model->getFirstMediaUrl('system_logo') ? $model->getFirstMediaUrl('system_logo') : asset('assets/lte/media/logos/favicon.png')); ?>" />

        <!-- Google Font: Source Sans Pro -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback"> 
		<!-- fontawesome-free -->
        <link rel="stylesheet" href="<?php echo e(asset('assets/lte')); ?>/plugins/fontawesome/css/all.min.css">
        <!-- icheck-bootstrap -->
        <link rel="stylesheet" href="<?php echo e(asset('assets/lte')); ?>/plugins/icheck-bootstrap/icheck-bootstrap.min.css">
        <!-- Theme style -->
        <link rel="stylesheet" href="<?php echo e(asset('assets/lte')); ?>/css/adminlte.css">
        <?php if(isset($current_lang) && $current_lang->dir == 'rtl'): ?>
            <link rel="stylesheet" href="<?php echo e(asset('assets/lte')); ?>/css/rtl.css">
        <?php else: ?>
            <link rel="stylesheet" href="<?php echo e(asset('assets/lte')); ?>/css/ltr.css">
        <?php endif; ?>

        
        <?php echo $__env->yieldContent('styles'); ?>
    </head>
    <body class="hold-transition login-page">

		<!-- Main content -->
		<?php echo $__env->yieldContent('content'); ?>

        <!-- jQuery -->
        <script src="<?php echo e(asset('assets/lte')); ?>/plugins/jquery/jquery.min.js"></script>
		<!-- Bootstrap 4 -->
        <script src="<?php echo e(asset('assets/lte')); ?>/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
		<!-- AdminLTE App -->
        <script src="<?php echo e(asset('assets/lte')); ?>/js/adminlte.js"></script>

        
		<?php echo $__env->make('adminLte.helpers.message-alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
        <?php echo $__env->yieldContent('scripts'); ?>

    </body>
</html><?php /**PATH C:\xampp\htdocs\resources\views/adminLte/auth/layout.blade.php ENDPATH**/ ?>