

<?php $__env->startSection('pageTitle'); ?>
    <?php echo app('translator')->get('localization::view.translations'); ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('styles'); ?>
    <link href="<?php echo e(asset('assets/modules/css/localization.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('assets/modules/js/localization.js')); ?>"></script>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>

<!--begin:: Form Card-->
<div class="card mb-5 mb-xl-10" id="translations_card">
    <!--begin::Card header-->
    
    <div class="card-header border-0">
        <div class="card-title">
            <h3 class="fw-bolder mt-4"><?php echo app('translator')->get('localization::view.edit_translations'); ?></h3>
        </div>
    </div>

    <div class="card-header align-items-center py-3 py-md-2">
        <!--begin::Card title-->
        <div class="card-title flex-column my-5">
            <ul class="nav nav-tabs nav-line-tabs nav-line-tabs-2x fs-6">
                <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e($lang->id == $current_language->id ? 'active' : ''); ?>" href="<?php echo e(fr_route('translations.edit', ['id' => $lang->id])); ?>"> <?php echo e($lang->name); ?> </a>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
        <!--end::Card title-->


        <!--begin::Card search-->
        <div class="card-search my-5">
            <div class="search-translations-wrapper w-500px">
                <!--begin::Input-->
                <input
                    type="search"
                    id="translations_search"
                    class="form-control form-control-lg"
                    id="search_on_phrases"
                    placeholder="<?php echo app('translator')->get('view.search_by_phrase'); ?>"
                    aria-describedby="basic-addon3"/>
                <!--end::Input-->
            </div>
        </div>
        <!--end::Card search-->
    </div>
    <!--begin::Card header-->
    <!--begin::Content-->
    <div>
        <!--begin::Form-->
        <form class="form" action="<?php echo e(fr_route('translations.update', ['lang_code' => $lang_code])); ?>" method="post">
            <!--begin::Card body-->
            <div class="card-body border-top p-9">
                <?php echo $__env->make('localization::adminLte.pages.translations.form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <!--end::Card body-->
            <!--begin::Actions-->
            <div class="card-footer shadow-sm d-flex justify-content-end py-6 px-9">
                <a href="<?php echo e(url()->previous()); ?>" class="btn btn-light btn-active-light-primary me-2"><?php echo app('translator')->get('view.discard'); ?></a>
                <button type="submit" class="btn btn-success"><?php echo app('translator')->get('view.update'); ?></button>
            </div>
            <!--end::Actions-->
        </form>
        <!--end::Form-->
    </div>
    <!--end::Content-->
</div>
<!--end:: Form Card-->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('localization::adminLte.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Modules/Localization\Resources/views/adminLte/pages/translations/index.blade.php ENDPATH**/ ?>